<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\Tentang;
use App\Models\Administrator;
use Session;

class Authcontroller extends Controller
{
    //
    public function login()
    {
        $tentang = Tentang::all();

        $data = [
            'tentang' => $tentang
        ];
        return view('admin.login')->with($data);
    }
    public function proses(Request $request)
    {
        $admin = Administrator::where('email', $request->email)->first();
        if($admin){
            if(Hash::check($request->password, $admin->password)){
                $request->session()->put('loginid', $admin->id);

                return redirect('/admin/home')->with(['success' => 'Berhasil Login']);
            } else {
                return back()->with(['error' => ' Email atau Password Salah']);
            }
        } else{
            return back()->with(['error' => 'Username atau Password Salah']);
        }  
    }
    public function logout(){
        if(Session::has('loginid')){
            Session::pull('loginid');
        return redirect('/admin')->with(['info' => 'Akun Telah di Logout']);
      }
    }
}
